/*
 * Decompiled with CFR 0.152.
 */
package rene.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import rene.gui.BasicIcon;
import rene.gui.CloseFrame;
import rene.gui.ColorIcon;
import rene.gui.Global;
import rene.gui.IconBarElement;
import rene.gui.IconBarListener;
import rene.gui.IconBarPanel;
import rene.gui.IconGroup;
import rene.gui.IconWithGif;
import rene.gui.MultipleIcon;
import rene.gui.MultipleStringIcon;
import rene.gui.MultipleToggleIcon;
import rene.gui.MyLabel;
import rene.gui.OnOffIcon;
import rene.gui.OverflowButton;
import rene.gui.Panel3D;
import rene.gui.PopupIcon;
import rene.gui.Separator;
import rene.gui.StateDisplay;
import rene.gui.ToggleIcon;

public class IconBar
extends Panel
implements KeyListener,
FocusListener,
IconBarListener {
    Vector Left = new Vector();
    Vector Right = new Vector();
    int W;
    Frame F;
    public final int Offset = 2;
    public String Resource = "/";
    int Focus = 0;
    public boolean TraverseFocus = true;
    public boolean UseSize = true;
    public boolean Vertical = false;
    boolean Overflow = false;
    boolean Shifted = false;
    OverflowButton OB;
    int OverflowX;
    IconBarListener L = null;
    boolean Shift;
    boolean Control;
    Window WHelp = null;

    public IconBar(Frame f2, boolean traversefocus) {
        this.F = f2;
        this.TraverseFocus = traversefocus;
        if (Global.ControlBackground != null) {
            this.setBackground(Global.ControlBackground);
        } else {
            this.setBackground(SystemColor.menu);
        }
        this.Resource = Global.getParameter("iconpath", "");
        BasicIcon.Size = Global.getParameter("iconsize", 20);
        this.setLayout(null);
        this.W = 4;
        this.addKeyListener(this);
        if (this.TraverseFocus) {
            this.addFocusListener(this);
        }
    }

    public IconBar(Frame f2) {
        this(f2, true);
    }

    public void forceRepaint() {
        BasicIcon i;
        super.repaint();
        Enumeration e2 = this.Left.elements();
        while (e2.hasMoreElements()) {
            i = (BasicIcon)e2.nextElement();
            i.repaint();
        }
        e2 = this.Right.elements();
        while (e2.hasMoreElements()) {
            i = (BasicIcon)e2.nextElement();
            i.repaint();
        }
    }

    public void keyPressed(KeyEvent e2) {
    }

    public void keyReleased(KeyEvent e2) {
        switch (e2.getKeyCode()) {
            case 39: {
                this.setFocus(this.Focus, false);
                ++this.Focus;
                if (this.Focus >= this.Left.size() + this.Right.size()) {
                    this.Focus = 0;
                }
                while (!(this.getIcon(this.Focus) instanceof BasicIcon)) {
                    ++this.Focus;
                    if (this.Focus < this.Left.size() + this.Right.size()) continue;
                    this.Focus = 0;
                    break;
                }
                this.setFocus(this.Focus, true);
                break;
            }
            case 37: {
                this.setFocus(this.Focus, false);
                --this.Focus;
                if (this.Focus < 0) {
                    this.Focus = this.Left.size() + this.Right.size() - 1;
                }
                while (!(this.getIcon(this.Focus) instanceof BasicIcon)) {
                    --this.Focus;
                    if (this.Focus >= 0) continue;
                    this.Focus = this.Left.size() + this.Right.size() - 1;
                    break;
                }
                this.setFocus(this.Focus, true);
                break;
            }
            case 32: {
                try {
                    BasicIcon icon = (BasicIcon)this.getIcon(this.Focus);
                    icon.mouseReleased(new MouseEvent(this, 502, 0L, 0, 0, 0, 1, false));
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void keyTyped(KeyEvent e2) {
    }

    public Object getIcon(int n) {
        if (n < this.Left.size()) {
            return this.Left.elementAt(n);
        }
        return this.Right.elementAt(this.Right.size() - 1 - (n - this.Left.size()));
    }

    public void focusGained(FocusEvent e2) {
        if (this.TraverseFocus) {
            this.setFocus(this.Focus, true);
        }
    }

    public void focusLost(FocusEvent e2) {
        if (this.TraverseFocus) {
            this.setFocus(this.Focus, false);
        }
    }

    public void setFocus(int n, boolean flag) {
        if (!this.TraverseFocus) {
            return;
        }
        try {
            if (n < this.Left.size()) {
                BasicIcon icon = (BasicIcon)this.Left.elementAt(n);
                icon.setFocus(flag);
            } else {
                BasicIcon icon = (BasicIcon)this.Right.elementAt(this.Right.size() - 1 - (n - this.Left.size()));
                icon.setFocus(flag);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addLeft(String name) {
        this.addLeft(new IconWithGif(this, name));
    }

    public void addLeft(BasicIcon i) {
        this.Left.addElement(i);
        this.add(i);
        this.W += i.width() + 2;
    }

    public void addRight(String name) {
        this.addRight(new IconWithGif(this, name));
    }

    public void addRight(BasicIcon i) {
        this.Right.addElement(i);
        this.add(i);
        this.W += i.width() + 2;
    }

    public void addToggleLeft(String name) {
        this.addLeft(new ToggleIcon(this, name));
    }

    public void addToggleRight(String name) {
        this.addRight(new ToggleIcon(this, name));
    }

    public void addOnOffLeft(String name) {
        this.addLeft(new OnOffIcon(this, name));
    }

    public void addOnOffRight(String name) {
        this.addRight(new OnOffIcon(this, name));
    }

    public void addToggleGroupLeft(String[] names, String[] breaks) {
        IconGroup g = new IconGroup(this, names, breaks);
        g.addLeft();
    }

    public void addToggleGroupRight(String[] names, String[] breaks) {
        IconGroup g = new IconGroup(this, names, breaks);
        g.addRight();
    }

    public void addToggleGroupLeft(String[] names) {
        this.addToggleGroupLeft(names, names);
    }

    public void addToggleGroupRight(String[] names) {
        this.addToggleGroupRight(names, names);
    }

    public void addToggleGroupLeft(String name, int n) {
        IconGroup g = new IconGroup(this, name, n);
        g.addLeft();
    }

    public void addToggleGroupRight(String name, int n) {
        IconGroup g = new IconGroup(this, name, n);
        g.addRight();
    }

    public void addToggleGroupLeft(String name, Color[] colors) {
        IconGroup g = new IconGroup(this, name, colors);
        g.addLeft();
    }

    public void addToggleGroupRight(String name, Color[] colors) {
        IconGroup g = new IconGroup(this, name, colors);
        g.addRight();
    }

    public void addSeparatorLeft() {
        if (this.Left.size() == 0) {
            return;
        }
        if (this.Left.lastElement() instanceof Separator) {
            return;
        }
        Separator s = new Separator(this);
        this.Left.addElement(s);
        this.add(s);
        this.W += s.width() + 2;
    }

    public void addSeparatorRight() {
        if (this.Right.size() == 0) {
            return;
        }
        if (this.Right.lastElement() instanceof Separator) {
            return;
        }
        Separator s = new Separator(this);
        this.Right.addElement(s);
        this.add(s);
        this.W += s.width() + 2;
    }

    public void addMultipleIconLeft(String name, int number) {
        this.addLeft(new MultipleIcon(this, name, number));
    }

    public void addMultipleIconRight(String name, int number) {
        this.addRight(new MultipleIcon(this, name, number));
    }

    public void addMultipleStringIconLeft(String name, String[] s) {
        this.addLeft(new MultipleStringIcon(this, name, s));
    }

    public void addMultipleStringIconRight(String name, String[] s) {
        this.addRight(new MultipleStringIcon(this, name, s));
    }

    public void addMultipleToggleIconLeft(String name, int number) {
        this.addLeft(new MultipleToggleIcon(this, name, number));
    }

    public void addMultipleToggleIconRight(String name, int number) {
        this.addRight(new MultipleToggleIcon(this, name, number));
    }

    public void addColorIconLeft(String name, Color[] colors) {
        this.addLeft(new ColorIcon(this, name, colors));
    }

    public void addColorIconRight(String name, Color[] colors) {
        this.addRight(new ColorIcon(this, name, colors));
    }

    public void addStateLeft(String name) {
        this.addLeft(new StateDisplay(this, name));
    }

    public void addStateRight(String name) {
        this.addRight(new StateDisplay(this, name));
    }

    public void doLayout() {
        if (this.OB != null) {
            this.remove(this.OB);
            this.OB = null;
        }
        if (this.Vertical) {
            int x = this.getSize().height;
            int k = 0;
            while (k < this.Right.size()) {
                IconBarElement i = (IconBarElement)this.Right.elementAt(k);
                i.setPosition(2, x -= i.width());
                x -= 2;
                ++k;
            }
            int xmax = x;
            x = 0;
            int k2 = 0;
            while (k2 < this.Left.size()) {
                IconBarElement i = (IconBarElement)this.Left.elementAt(k2);
                i.setPosition(2, x);
                x += i.width();
                if ((x += 2) + BasicIcon.Size > xmax) {
                    x = -1000;
                }
                ++k2;
            }
        } else {
            int x = this.getSize().width;
            int k = 0;
            while (k < this.Right.size()) {
                IconBarElement i = (IconBarElement)this.Right.elementAt(k);
                i.setPosition(x -= i.width(), 2);
                x -= 2;
                ++k;
            }
            int xmax = x;
            x = 0;
            int k3 = 0;
            while (k3 < this.Left.size()) {
                IconBarElement i = (IconBarElement)this.Left.elementAt(k3);
                i.setPosition(x, 2);
                x += i.width();
                if ((x += 2) + BasicIcon.Size > xmax - 10 && k3 < this.Left.size() - 1) {
                    this.Overflow = true;
                    this.OverflowX = x;
                    this.OB = new OverflowButton(this, this.Shifted);
                    this.add(this.OB);
                    this.OB.setSize(10, BasicIcon.Size);
                    this.OB.setLocation(xmax - 10 - 2, 2);
                    if (this.Shifted) {
                        x = xmax - 10 - 4;
                        int l = this.Left.size() - 1;
                        while (l >= 0) {
                            i = (IconBarElement)this.Left.elementAt(l);
                            i.setPosition(x -= i.width(), 2);
                            if ((x -= 2) - BasicIcon.Size < 0) {
                                x -= 1000;
                            }
                            --l;
                        }
                        break;
                    }
                    x = -1000;
                }
                ++k3;
            }
        }
    }

    public void setShifted(boolean flag) {
        this.Shifted = flag;
        this.doLayout();
    }

    public Dimension getPreferredSize() {
        if (this.Vertical) {
            if (!this.UseSize) {
                return new Dimension(BasicIcon.Size + 4, 10);
            }
            return new Dimension(BasicIcon.Size + 4, this.W + 10);
        }
        if (!this.UseSize) {
            return new Dimension(10, BasicIcon.Size + 4);
        }
        return new Dimension(this.W + 10, BasicIcon.Size + 4);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setIconBarListener(IconBarListener l) {
        this.L = l;
    }

    public void removeIconBarListener(IconBarListener l) {
        this.L = null;
    }

    public void iconPressed(String name, boolean shift, boolean control) {
        this.Shift = shift;
        this.Control = control;
        this.removeHelp();
        if (this.L != null) {
            this.L.iconPressed(name);
        }
    }

    public boolean isShiftPressed() {
        return this.Shift;
    }

    public boolean isControlPressed() {
        return this.Control;
    }

    public void clearShiftControl() {
        this.Control = false;
        this.Shift = false;
    }

    public synchronized void displayHelp(IconBarElement i, String text) {
        if (this.F == null || this.WHelp != null) {
            return;
        }
        Point P = i.getPosition();
        this.WHelp = new Window(this.F);
        Panel p = new Panel();
        StringTokenizer t = new StringTokenizer(text, "+");
        p.setLayout(new GridLayout(0, 1));
        while (t.hasMoreTokens()) {
            p.add(new MyLabel(t.nextToken()));
        }
        this.WHelp.add("Center", p);
        this.WHelp.pack();
        Dimension d2 = this.WHelp.getSize();
        Dimension ds = this.getToolkit().getScreenSize();
        int x = P.x;
        int y = P.y + i.width() + 10;
        if (x + d2.width > ds.width) {
            x = ds.width - d2.width;
        }
        if (y + d2.height > ds.height) {
            y = P.y - i.width() - d2.height;
        }
        ((Component)this.WHelp).setLocation(x, y);
        ((Component)this.WHelp).setBackground(new Color(255, 255, 220));
        this.WHelp.setForeground(Color.black);
        this.WHelp.setVisible(true);
    }

    public synchronized void removeHelp() {
        if (this.WHelp == null) {
            return;
        }
        this.WHelp.setVisible(false);
        this.WHelp.dispose();
        this.WHelp = null;
    }

    private BasicIcon find(String name) {
        BasicIcon i2;
        int k = 0;
        while (k < this.Left.size()) {
            try {
                i2 = (BasicIcon)this.Left.elementAt(k);
                if (i2.getName().equals(name)) {
                    return i2;
                }
            }
            catch (Exception i2) {
                // empty catch block
            }
            ++k;
        }
        k = 0;
        while (k < this.Right.size()) {
            try {
                i2 = (BasicIcon)this.Right.elementAt(k);
                if (i2.getName().equals(name)) {
                    return i2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++k;
        }
        return null;
    }

    public void setEnabled(String name, boolean flag) {
        BasicIcon icon = this.find(name);
        if (icon == null) {
            return;
        }
        icon.setEnabled(flag);
    }

    public void toggle(String name) {
        BasicIcon icon = this.find(name);
        if (icon == null || !(icon instanceof ToggleIcon)) {
            return;
        }
        ((ToggleIcon)icon).setState(true);
    }

    public boolean have(String name) {
        return this.find(name) != null;
    }

    public void unselect(String name) {
        BasicIcon icon = this.find(name);
        if (icon == null || !(icon instanceof ToggleIcon)) {
            return;
        }
        ((ToggleIcon)icon).unselect();
    }

    public void toggle(String name, int n) {
        this.toggle(String.valueOf(name) + n);
    }

    public void setState(String name, boolean flag) {
        BasicIcon icon = this.find(name);
        if (icon != null && icon instanceof ToggleIcon) {
            ((ToggleIcon)icon).setState(flag);
        }
        if (icon != null && icon instanceof MultipleToggleIcon) {
            ((MultipleToggleIcon)icon).setState(flag);
        }
    }

    public boolean getState(String name) {
        BasicIcon icon = this.find(name);
        if (icon == null || !(icon instanceof ToggleIcon)) {
            return false;
        }
        return ((ToggleIcon)icon).getState();
    }

    public int getToggleState(String name) {
        BasicIcon icon = this.find(String.valueOf(name) + 0);
        if (icon == null || !(icon instanceof ToggleIcon)) {
            return -1;
        }
        int n = ((ToggleIcon)icon).countPeers();
        int i = 0;
        while (i < n) {
            if (this.getState(String.valueOf(name) + i)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getMultipleState(String name) {
        IconBarElement i;
        int k = 0;
        while (k < this.Left.size()) {
            i = (IconBarElement)this.Left.elementAt(k);
            if (i.getName().equals(name) && i instanceof MultipleIcon) {
                return ((MultipleIcon)i).getSelected();
            }
            ++k;
        }
        k = 0;
        while (k < this.Right.size()) {
            i = (IconBarElement)this.Right.elementAt(k);
            if (i.getName().equals(name) && i instanceof MultipleIcon) {
                return ((MultipleIcon)i).getSelected();
            }
            ++k;
        }
        return -1;
    }

    public void setMultipleState(String name, int state) {
        IconBarElement i;
        int k = 0;
        while (k < this.Left.size()) {
            i = (IconBarElement)this.Left.elementAt(k);
            if (i.getName().equals(name) && i instanceof MultipleIcon) {
                ((MultipleIcon)i).setSelected(state);
            }
            ++k;
        }
        k = 0;
        while (k < this.Right.size()) {
            i = (IconBarElement)this.Right.elementAt(k);
            if (i.getName().equals(name) && i instanceof MultipleIcon) {
                ((MultipleIcon)i).setSelected(state);
            }
            ++k;
        }
    }

    public boolean isSet(String name) {
        BasicIcon icon = this.find(name);
        if (icon == null) {
            return false;
        }
        return icon.isSet();
    }

    public void unset(String name) {
        BasicIcon icon = this.find(name);
        if (icon != null) {
            icon.unset();
        }
    }

    public void getKey(KeyEvent e2) {
        this.processKeyEvent(e2);
    }

    public void setSize(int size) {
        BasicIcon.Size = size;
    }

    public void removeAll() {
        Enumeration e2 = this.Left.elements();
        while (e2.hasMoreElements()) {
            this.remove((BasicIcon)e2.nextElement());
        }
        e2 = this.Right.elements();
        while (e2.hasMoreElements()) {
            this.remove((BasicIcon)e2.nextElement());
        }
        this.Left.removeAllElements();
        this.Right.removeAllElements();
    }

    public String getHelp(String name) {
        return "";
    }

    public static void main(String[] args) {
        CloseFrame f2 = new CloseFrame("Test");
        IconBar IA = new IconBar(f2);
        IA.Vertical = true;
        IA.setSize(30);
        IA.Resource = "/icons/";
        IA.addLeft("back");
        IA.addLeft("undo");
        IA.addSeparatorLeft();
        IA.addOnOffLeft("grid");
        IA.addSeparatorLeft();
        IA.addToggleLeft("delete");
        IA.addSeparatorLeft();
        String[] tg = new String[]{"zoom", "draw", "", "rename", "edit"};
        IA.addToggleGroupLeft(tg);
        IA.addSeparatorLeft();
        IA.addMultipleToggleIconLeft("macro", 3);
        IA.addSeparatorLeft();
        String[] tga = new String[]{"zoom", "draw", "rename", "edit"};
        IA.addLeft(new PopupIcon(IA, tga));
        IA.addSeparatorLeft();
        String[] st = new String[]{"A", "B", "C", "D"};
        IA.addMultipleStringIconLeft("strings", st);
        Color[] col = new Color[]{Color.BLACK, Color.RED, Color.GREEN};
        IA.addStateLeft("needsave");
        IA.addColorIconLeft("color", col);
        f2.add("Center", new IconBarPanel(new Panel3D(IA), new Panel3D(new Panel())));
        f2.pack();
        f2.center();
        IA.setIconBarListener(IA);
        f2.setVisible(true);
    }

    public void iconPressed(String name) {
        System.out.println(name);
    }
}

